package project

import (
	"context"

	"a.yandex-team.ru/security/impulse/models"
)

type Usecase interface {
	Create(ctx context.Context, project *models.Project) (models.Project, error)
	Update(ctx context.Context, project *models.Project) error
	GetByID(ctx context.Context, id int) (*models.Project, error)
	GetIDBySlug(ctx context.Context, slug string) (int, error)
	GetByOrganizationIDAndProjectID(ctx context.Context, organizationID int, projectID int) (*models.Project, error)
	ListByOrganizationID(ctx context.Context, organizationID int) ([]*models.ProjectInfo, error)
	ListWithEnabledNotifications(ctx context.Context) ([]*models.ProjectInfo, error)
	DeleteByID(ctx context.Context, id int) error
	GetStatisticsByID(ctx context.Context, id int) (*models.ProjectStatistics, error)
	ListTags(ctx context.Context) ([]string, error)
}
