package scan

import (
	"context"

	"a.yandex-team.ru/security/impulse/models"
)

type Usecase interface {
	GetByProjectIDAndScanTypeName(ctx context.Context, projectID int, scanTypeName string) (*models.Scan, error)
	GetOrCreateByProjectIDAndScanTypeName(ctx context.Context, projectID int, scanTypeName string) (*models.Scan, error)
	CreateScansFromWorkflowID(ctx context.Context, projectID int, workflowID string) ([]*models.Scan, error)
	CreateScansFromAnalysersList(ctx context.Context, projectID int, analysers models.TaskAnalysers) ([]*models.Scan, error)
	GetByID(ctx context.Context, id int) (*models.Scan, error)
	DeleteByID(ctx context.Context, id int) error
	GetInfoByProjectIDAndScanTypeName(ctx context.Context, projectID int, scanTypeName string) (*models.ScanInfo, error)
}
