package scantype

import (
	"context"

	"a.yandex-team.ru/security/impulse/api/repositories/scantype"
	"a.yandex-team.ru/security/impulse/models"
)

type scanTypeUsecase struct {
	repo scantype.Repository
}

func NewScanTypeUsecase(repo scantype.Repository) Usecase {
	return &scanTypeUsecase{
		repo: repo,
	}
}

func (m *scanTypeUsecase) List(ctx context.Context) ([]*models.ScanType, error) {
	return m.repo.List(ctx)
}

func (m *scanTypeUsecase) ListByProjectID(ctx context.Context, projectID int) ([]*models.ScanType, error) {
	return m.repo.ListByProjectID(ctx, projectID)
}

func (m *scanTypeUsecase) GetByID(ctx context.Context, id int) (*models.ScanType, error) {
	return m.repo.GetByID(ctx, id)
}

func (m *scanTypeUsecase) GetScanTypeParameters(ctx context.Context, scanTypeID int) (s []*models.ScanParameter, err error) {
	return m.repo.GetScanTypeParameters(ctx, scanTypeID)
}

func (m *scanTypeUsecase) GetScanTypeDisplayName(ctx context.Context, scanTypeName string) (string, error) {
	return m.repo.GetScanTypeDisplayName(ctx, scanTypeName)
}
