package scantype

import (
	"context"

	"a.yandex-team.ru/security/impulse/models"
)

type Usecase interface {
	List(ctx context.Context) ([]*models.ScanType, error)
	ListByProjectID(ctx context.Context, projectID int) ([]*models.ScanType, error)
	GetByID(ctx context.Context, id int) (*models.ScanType, error)
	GetScanTypeParameters(ctx context.Context, scanTypeID int) ([]*models.ScanParameter, error)
	GetScanTypeDisplayName(ctx context.Context, scanTypeName string) (string, error)
}
