package task

import (
	"context"

	"a.yandex-team.ru/security/impulse/models"
)

type Usecase interface {
	Create(ctx context.Context, s *models.Task) error
	Update(ctx context.Context, s *models.Task) error
	GetByTaskID(ctx context.Context, taskID string) (*models.Task, error)
	CheckFinished(ctx context.Context, taskID string) (bool, error)
	GetLastTemplate(ctx context.Context, projectID int) (*models.TaskResponseDTO, error)
	List(ctx context.Context, organizationID, projectID, limit, offset int) ([]*models.TaskResponseDTO, error)
	ListByOrganizationID(ctx context.Context, organizationID, limit, offset int) ([]*models.TaskResponseDTO, error)
	GetTotal(ctx context.Context, organizationID, projectID int) (int, error)
	GetTotalByOrganizationID(ctx context.Context, organizationID int) (int, error)
	StatusToString(s *models.Task) string
	IsValidStatus(status models.TaskStatus) bool
	IsFinalStatus(status models.TaskStatus) bool
	NormalizeTaskParameters(params models.TaskParameters) (models.TaskParameters, error)
}
