package vulnerability

import (
	"context"
	"time"

	"a.yandex-team.ru/security/impulse/models"
)

type Usecase interface {
	FetchByScanID(ctx context.Context, scanID int) ([]*models.Vulnerability, error)
	UpdateByScanID(ctx context.Context, scanID int, vulnerabilities []*models.Vulnerability) error
	InsertByScanIDAndLastUpdateToken(ctx context.Context, scanID int, lastUpdateToken string,
		vulnerabilities []*models.Vulnerability) ([]*models.Vulnerability, error)
	UpdateFromScanInstanceVulnerabilities(ctx context.Context, scanInstanceID int) error
	FetchByScanInstanceID(ctx context.Context, scanInstanceID int, limit int, offset int) ([]*models.Vulnerability, error)
	GetByVulnerabilityIDAndScanInstanceID(ctx context.Context, vulnerabilityID int,
		scanInstanceID int) (*models.Vulnerability, error)
	GetByVulnerabilityID(ctx context.Context, vulnerabilityID int) (*models.Vulnerability, error)
	ListVulnerabilityCategories(ctx context.Context, scanTypeID, scanID int) ([]*models.VulnerabilityCategoryResponseDTO, error)
	UpdateStatusByID(ctx context.Context, status models.StatusType, id int) error
	BatchUpdateStatus(ctx context.Context, status models.StatusType, IDs []int) error
	UpdateTrackerTicketByID(ctx context.Context, trackerTicket string, id int) error
	FetchByScanInstanceIDAndCategoryID(ctx context.Context, scanInstanceID int, categoryID int,
		limit int, offset int) ([]*models.Vulnerability, error)
	FetchByScanInstances(ctx context.Context, scanInstances []*models.ScanInstance,
		limit int, offset int, filterMap map[string]interface{}) ([]*models.Vulnerability, error)
	FetchLatestByOrganizationID(ctx context.Context, organizationID int,
		limit int, offset int, filterMap map[string]interface{}) ([]*models.Vulnerability, error)
	FetchLatestByProjectIDWithoutTicket(ctx context.Context, projectID int, after time.Time,
		limit int, offset int, filterMap map[string]interface{}) ([]*models.Vulnerability, error)
}
