package vulnerabilitycategory

import (
	"context"

	"a.yandex-team.ru/security/impulse/models"
)

type Usecase interface {
	ListByScanType(ctx context.Context, scanTypeID int) (map[string]int, error)
	Insert(ctx context.Context, scanTypeID int, category string) (int, error)
	ListByScanInstance(ctx context.Context, scanInstance models.ScanInstance) ([]*models.VulnerabilityCategory, error)
	GetInfoByScanInstanceAndID(ctx context.Context, scanInstance models.ScanInstance,
		id int) (*models.VulnerabilityCategoryStatistics, error)
}
