package vulnerabilitycategory

import (
	"context"

	"a.yandex-team.ru/security/impulse/api/repositories/vulnerabilitycategory"
	"a.yandex-team.ru/security/impulse/models"
)

type vulnerabilityCategoryUsecase struct {
	repo vulnerabilitycategory.Repository
}

func NewVulnerabilityCategoryUsecase(repo vulnerabilitycategory.Repository) Usecase {
	return &vulnerabilityCategoryUsecase{
		repo: repo,
	}
}

func (m *vulnerabilityCategoryUsecase) ListByScanType(ctx context.Context, scanTypeID int) (map[string]int, error) {
	categories, err := m.repo.ListByScanType(ctx, scanTypeID)
	if err != nil {
		return nil, err
	}
	categoryMap := make(map[string]int)
	for _, category := range categories {
		categoryMap[category.Name] = category.ID
	}
	return categoryMap, nil
}

func (m *vulnerabilityCategoryUsecase) Insert(ctx context.Context, scanTypeID int, category string) (int, error) {
	return m.repo.Insert(ctx, scanTypeID, category)
}

func (m *vulnerabilityCategoryUsecase) ListByScanInstance(ctx context.Context, scanInstance models.ScanInstance) ([]*models.VulnerabilityCategory, error) {
	return m.repo.ListByScanInstance(ctx, scanInstance)
}

func (m *vulnerabilityCategoryUsecase) GetInfoByScanInstanceAndID(ctx context.Context, scanInstance models.ScanInstance,
	id int) (*models.VulnerabilityCategoryStatistics, error) {
	return m.repo.GetStatisticsByScanInstanceIDAndCategoryID(ctx, scanInstance.ID, id)
}
