package vulnerabilityhistoryaction

import (
	"context"

	"a.yandex-team.ru/security/impulse/models"
)

type Usecase interface {
	FetchByVulnerabilityID(ctx context.Context, vulnerabilityID int) ([]*models.VulnerabilityHistoryAction, error)
	AddComment(ctx context.Context, vulnerabilityID int, login string, commentText string) error
	AddStatusChange(ctx context.Context, vulnerabilityID int, login string, status models.StatusType) error
	BatchAddStatusChange(ctx context.Context, vulnerabilityIDs []int, login string, status models.StatusType) error
}
