package vulnerabilityhistoryaction

import (
	"context"

	"a.yandex-team.ru/security/impulse/api/repositories/vulnerabilityhistoryaction"
	"a.yandex-team.ru/security/impulse/models"
)

type VulnerabilityHistoryActionUsecase struct {
	repo vulnerabilityhistoryaction.Repository
}

func NewVulnerabilityHistoryActionUsecase(repo vulnerabilityhistoryaction.Repository) Usecase {
	return &VulnerabilityHistoryActionUsecase{repo: repo}
}

func (v VulnerabilityHistoryActionUsecase) FetchByVulnerabilityID(ctx context.Context, vulnerabilityID int) ([]*models.VulnerabilityHistoryAction, error) {
	vulnerabilityHistoryActions, err := v.repo.FetchByVulnerabilityID(ctx, vulnerabilityID)
	if err != nil {
		return nil, err
	}
	return vulnerabilityHistoryActions, nil
}

func (v VulnerabilityHistoryActionUsecase) AddComment(ctx context.Context, vulnerabilityID int, login string,
	commentText string) error {
	actionType := models.AddCommentAction
	historyActions := []models.VulnerabilityHistoryAction{
		{
			VulnerabilityID: vulnerabilityID,
			ActionType:      &actionType,
			ActionText:      commentText,
			Login:           login,
		},
	}
	err := v.repo.AddHistoryActions(ctx, historyActions)
	return err
}

func (v VulnerabilityHistoryActionUsecase) AddStatusChange(ctx context.Context, vulnerabilityID int,
	login string, status models.StatusType) error {
	actionType := models.ChangeStatusAction
	historyActions := []models.VulnerabilityHistoryAction{
		{
			VulnerabilityID: vulnerabilityID,
			ActionType:      &actionType,
			ActionText:      string(status),
			Login:           login,
		},
	}
	err := v.repo.AddHistoryActions(ctx, historyActions)
	return err
}

func (v VulnerabilityHistoryActionUsecase) BatchAddStatusChange(ctx context.Context, vulnerabilityIDs []int,
	login string, status models.StatusType) error {
	actionType := models.ChangeStatusAction
	historyActions := []models.VulnerabilityHistoryAction{}
	for _, vulnerabilityID := range vulnerabilityIDs {
		historyActions = append(historyActions, models.VulnerabilityHistoryAction{
			VulnerabilityID: vulnerabilityID,
			ActionType:      &actionType,
			ActionText:      string(status),
			Login:           login,
		})
	}
	err := v.repo.AddHistoryActions(ctx, historyActions)
	return err
}
