package vulnerabilitytotalstatistics

import (
	"context"

	"a.yandex-team.ru/security/impulse/api/repositories/vulnerabilitytotalstatistics"
)

type VulnerabilityTotalStatisticsUsecase struct {
	repo vulnerabilitytotalstatistics.Repository
}

func NewVulnerabilityTotalStatisticsUsecase(repo vulnerabilitytotalstatistics.Repository) Usecase {
	return &VulnerabilityTotalStatisticsUsecase{repo: repo}
}

func (v *VulnerabilityTotalStatisticsUsecase) UpdateStatisticsByProjectID(ctx context.Context,
	projectID int) error {
	return v.repo.UpdateStatisticsByProjectID(ctx, projectID)
}
