package config

import (
	"time"

	"a.yandex-team.ru/library/go/yandex/tvm"
	"a.yandex-team.ru/security/impulse/api/internal/abc"
	"a.yandex-team.ru/security/impulse/api/internal/db"
	"a.yandex-team.ru/security/impulse/api/internal/insights"
)

type (
	Config struct {
		UpstreamURL      string
		HTTPPort         uint32
		ImpulseTvmID     tvm.ClientID
		UseAuth          bool
		Debug            bool
		DBConn           string
		DBPassword       string
		DBRetries        int
		SecnotifyToken   string
		ABCOAuthToken    string
		ABCEndpoint      string
		InsightsURL      string
		InsightsDstTVMID tvm.ClientID
	}
)

func (c *Config) DBConfig() *db.Options {
	return &db.Options{
		DSN:             c.DBConn,
		Password:        c.DBPassword,
		QueryRetries:    c.DBRetries,
		MaxOpenConns:    10,
		MaxIdleConns:    2,
		ConnMaxLifetime: time.Hour,
	}
}

func (c *Config) ABCConfig() *abc.Options {
	return &abc.Options{
		Endpoint:   c.ABCEndpoint,
		OAuthToken: c.ABCOAuthToken,
	}
}

func (c *Config) InsightsConfig() *insights.Options {
	return &insights.Options{
		Endpoint: c.InsightsURL,
		DstTvmID: c.InsightsDstTVMID,
	}
}
