package secnotify

import (
	"context"
	"encoding/json"
	"fmt"

	"a.yandex-team.ru/security/impulse/models"
)

const SecauditScanV2 = "secaudit_scan_v2"

type (
	SecauditTemplateParameters struct {
		TotalNotFalseVulnerabilitiesCount    int    `json:"total_count"`
		BlockerNotFalseVulnerabilitiesCount  int    `json:"blocker_count"`
		CriticalNotFalseVulnerabilitiesCount int    `json:"critical_count"`
		MediumNotFalseVulnerabilitiesCount   int    `json:"medium_count"`
		LowNotFalseVulnerabilitiesCount      int    `json:"low_count"`
		InfoNotFalseVulnerabilitiesCount     int    `json:"info_count"`
		ReportURL                            string `json:"report_url"`
	}
)

func (c *Controller) buildSecauditReport(ctx context.Context, startrekTicket string, report *models.WebhookReport) ([]byte, error) {
	projectStatistics, err := c.projectUsecase.GetStatisticsByID(ctx, report.ProjectID)
	if err != nil {
		return nil, err
	}

	reportURL := fmt.Sprintf("https://impulse.sec.yandex-team.ru/organizations/%d/projects/%d",
		report.OrganizationID, report.ProjectID)
	template := &Template{
		TemplateID: SecauditScanV2,
		IssueID:    startrekTicket,
		Parameters: SecauditTemplateParameters{
			TotalNotFalseVulnerabilitiesCount:    projectStatistics.TotalNotFalseVulnerabilitiesCount,
			BlockerNotFalseVulnerabilitiesCount:  projectStatistics.BlockerNotFalseVulnerabilitiesCount,
			CriticalNotFalseVulnerabilitiesCount: projectStatistics.CriticalNotFalseVulnerabilitiesCount,
			MediumNotFalseVulnerabilitiesCount:   projectStatistics.MediumNotFalseVulnerabilitiesCount,
			LowNotFalseVulnerabilitiesCount:      projectStatistics.LowNotFalseVulnerabilitiesCount,
			InfoNotFalseVulnerabilitiesCount:     projectStatistics.InfoNotFalseVulnerabilitiesCount,
			ReportURL:                            reportURL,
		},
	}

	data, _ := json.Marshal(template)

	return data, nil
}
