package infra

import (
	"context"

	"a.yandex-team.ru/library/go/yandex/tvm/tvmtool"
	"a.yandex-team.ru/security/impulse/api/internal/abc"
	"a.yandex-team.ru/security/impulse/api/internal/db"
	"a.yandex-team.ru/security/impulse/api/internal/insights"
	"a.yandex-team.ru/security/impulse/api/webhook/internal/config"
)

type Infra struct {
	ctx      context.Context
	CFG      config.Config
	TVM      *tvmtool.Client
	ABC      *abc.API
	Insights insights.API
	DB       *db.DB
}

func New(cfg config.Config) *Infra {
	return &Infra{
		ctx: context.Background(),
		CFG: cfg,
	}
}

func (c *Infra) Start() (err error) {
	c.ABC = abc.New(c.CFG.ABCConfig())
	c.Insights = insights.New(c.CFG.InsightsConfig())

	if c.CFG.UseAuth {
		c.TVM, err = tvmtool.NewAnyClient()
		if err != nil {
			return
		}
		c.Insights.SetTVMClient(c.TVM)
	}

	c.DB, err = db.New(c.CFG.DBConfig())
	if err != nil {
		return err
	}
	return
}

func (c *Infra) Done() (err error) {

	return
}
