package server

import (
	"a.yandex-team.ru/security/impulse/api/webhook/internal/controllers"
	"a.yandex-team.ru/security/impulse/api/webhook/internal/controllers/insights"
	"a.yandex-team.ru/security/impulse/api/webhook/internal/controllers/secnotify"
	"a.yandex-team.ru/security/impulse/api/webhook/internal/infra"
)

type serverControllers struct {
	Secnotify controllers.Controller
	Insights  controllers.Controller
}

func newControllers(infra *infra.Infra) serverControllers {
	return serverControllers{
		Secnotify: &secnotify.Controller{Infra: infra},
		Insights:  &insights.Controller{Infra: infra},
	}
}
