package blackduck

import (
	"a.yandex-team.ru/security/impulse/api/worker/internal/dedup/common"
	"a.yandex-team.ru/security/impulse/models"
)

type BlackduckDedupImpl struct{}

func NewDedupImpl() common.DedupImpl {
	return &BlackduckDedupImpl{}
}

func (d BlackduckDedupImpl) UnmarshalReport(reportRaw []byte) (*common.ReportResult, error) {
	return common.UnmarshalReport(reportRaw)
}

func (d BlackduckDedupImpl) Filter(vulns []*models.NewVulnerabilityDeduplicationRequestDTO, includeFilenamePatterns []string,
	excludeFilenamePatterns []string) ([]*models.NewVulnerabilityDeduplicationRequestDTO, error) {
	return common.Filter("package_name", vulns, includeFilenamePatterns, excludeFilenamePatterns)
}

func (d BlackduckDedupImpl) Deduplicate(oldVulns []*models.VulnerabilityDeduplicationResponseDTO, vulns []*models.NewVulnerabilityDeduplicationRequestDTO) ([]*models.NewVulnerabilityDeduplicationRequestDTO, []*models.DeduplicatedVulnerabilityDeduplicationRequestDTO, error) {
	oldVulnsExcludeMap := map[int]bool{}
	newVulns := make([]*models.NewVulnerabilityDeduplicationRequestDTO, 0)
	dedupVulns := make([]*models.DeduplicatedVulnerabilityDeduplicationRequestDTO, 0)

	for _, vuln := range vulns {
		match := false
		for _, oldVuln := range oldVulns {
			if _, ok := oldVulnsExcludeMap[oldVuln.ID]; ok {
				continue
			}

			if (vuln.KeyProperties["is_arcadia"] == true ||
				vuln.KeyProperties["folder"] == oldVuln.KeyProperties["folder"]) &&
				vuln.KeyProperties["id"] == oldVuln.KeyProperties["id"] &&
				vuln.KeyProperties["version"] == oldVuln.KeyProperties["version"] &&
				vuln.KeyProperties["package_name"] == oldVuln.KeyProperties["package_name"] {
				match = true
				oldVulnsExcludeMap[oldVuln.ID] = true
				dedupVulns = append(dedupVulns, &models.DeduplicatedVulnerabilityDeduplicationRequestDTO{
					ID:                oldVuln.ID,
					Severity:          vuln.Severity,
					Category:          vuln.Category,
					KeyProperties:     vuln.KeyProperties,
					DisplayProperties: vuln.DisplayProperties,
				})
				break
			}
		}
		if !match {
			newVulns = append(newVulns, vuln)
		}
	}

	return newVulns, dedupVulns, nil
}
