package rips

import (
	"a.yandex-team.ru/security/impulse/api/worker/internal/dedup/common"
	"a.yandex-team.ru/security/impulse/models"
)

type RipsDedupImpl struct{}

func NewDedupImpl() common.DedupImpl {
	return &RipsDedupImpl{}
}

func (d RipsDedupImpl) UnmarshalReport(reportRaw []byte) (*common.ReportResult, error) {
	return common.UnmarshalReport(reportRaw)
}

func (d RipsDedupImpl) Filter(vulns []*models.NewVulnerabilityDeduplicationRequestDTO, includeFilenamePatterns []string,
	excludeFilenamePatterns []string) ([]*models.NewVulnerabilityDeduplicationRequestDTO, error) {
	return common.Filter("filename", vulns, includeFilenamePatterns, excludeFilenamePatterns)
}

func (d RipsDedupImpl) Deduplicate(oldVulns []*models.VulnerabilityDeduplicationResponseDTO, vulns []*models.NewVulnerabilityDeduplicationRequestDTO) ([]*models.NewVulnerabilityDeduplicationRequestDTO, []*models.DeduplicatedVulnerabilityDeduplicationRequestDTO, error) {
	oldVulnsExcludeMap := map[int]bool{}
	newVulns := make([]*models.NewVulnerabilityDeduplicationRequestDTO, 0)
	dedupVulns := make([]*models.DeduplicatedVulnerabilityDeduplicationRequestDTO, 0)

	for _, vuln := range vulns {
		match := false
		for _, oldVuln := range oldVulns {
			if _, ok := oldVulnsExcludeMap[oldVuln.ID]; ok {
				continue
			}

			if vuln.KeyProperties["uuid"] == oldVuln.KeyProperties["uuid"] {
				match = true
				oldVulnsExcludeMap[oldVuln.ID] = true
				dedupVulns = append(dedupVulns, &models.DeduplicatedVulnerabilityDeduplicationRequestDTO{
					ID:                oldVuln.ID,
					Severity:          vuln.Severity,
					Category:          vuln.Category,
					KeyProperties:     vuln.KeyProperties,
					DisplayProperties: vuln.DisplayProperties,
				})
				break
			}
		}
		if !match {
			newVulns = append(newVulns, vuln)
		}
	}

	return newVulns, dedupVulns, nil
}
