package sonar

import (
	"a.yandex-team.ru/security/impulse/api/worker/internal/dedup/common"
	"a.yandex-team.ru/security/impulse/models"
)

type SonarDedupImpl struct{}

func NewDedupImpl() common.DedupImpl {
	return &SonarDedupImpl{}
}

func (d SonarDedupImpl) UnmarshalReport(reportRaw []byte) (*common.ReportResult, error) {
	return common.UnmarshalReport(reportRaw)
}

func (d SonarDedupImpl) Filter(vulns []*models.NewVulnerabilityDeduplicationRequestDTO, includeFilenamePatterns []string,
	excludeFilenamePatterns []string) ([]*models.NewVulnerabilityDeduplicationRequestDTO, error) {
	return common.Filter("filename", vulns, includeFilenamePatterns, excludeFilenamePatterns)
}

func (d SonarDedupImpl) Deduplicate(oldVulns []*models.VulnerabilityDeduplicationResponseDTO, vulns []*models.NewVulnerabilityDeduplicationRequestDTO) ([]*models.NewVulnerabilityDeduplicationRequestDTO, []*models.DeduplicatedVulnerabilityDeduplicationRequestDTO, error) {
	oldVulnsFileMap := map[string][]*models.VulnerabilityDeduplicationResponseDTO{}
	for _, vuln := range oldVulns {
		filename := vuln.KeyProperties["filename"].(string)
		oldVulnsFileMap[filename] = append(oldVulnsFileMap[filename], vuln)
	}

	vulnsFileMap := map[string][]*models.NewVulnerabilityDeduplicationRequestDTO{}
	for _, vuln := range vulns {
		filename := vuln.KeyProperties["filename"].(string)
		vulnsFileMap[filename] = append(vulnsFileMap[filename], vuln)
	}

	newVulns := make([]*models.NewVulnerabilityDeduplicationRequestDTO, 0)
	dedupVulns := make([]*models.DeduplicatedVulnerabilityDeduplicationRequestDTO, 0)

	for file, fileVulns := range vulnsFileMap {
		fileOldVulns, ok := oldVulnsFileMap[file]
		if !ok {
			newVulns = append(newVulns, fileVulns...)
			continue
		}
		oldVulnsExcludeMap := map[int]bool{}
		vulnsExcludeMap := map[int]bool{}
		for step := 0; step < 4; step++ {
			for vulnID, vuln := range fileVulns {
				if _, ok := vulnsExcludeMap[vulnID]; ok {
					continue
				}
				match := false
				for oldVulnID, oldVuln := range fileOldVulns {
					if _, ok := oldVulnsExcludeMap[oldVulnID]; ok {
						continue
					}

					rule := vuln.KeyProperties["rule"]
					oldRule := oldVuln.KeyProperties["rule"]

					lineNumber := vuln.KeyProperties["line_number"]
					oldLineNumber := oldVuln.KeyProperties["line_number"]

					lineHash := vuln.KeyProperties["line_hash"]
					oldLineHash := oldVuln.KeyProperties["line_hash"]

					description := vuln.KeyProperties["description"]
					oldDescription := oldVuln.KeyProperties["description"]

					switch step {
					case 0:
						if rule == oldRule && lineNumber == oldLineNumber && lineHash == oldLineHash {
							match = true
						}
					case 1:
						if rule == oldRule && description == oldDescription && lineHash == oldLineHash {
							match = true
						}
					case 2:
						if rule == oldRule && description == oldDescription && lineNumber == oldLineNumber {
							match = true
						}
					case 3:
						if rule == oldRule && lineHash == oldLineHash {
							match = true
						}
					}
					if match {
						// MATCH
						vulnsExcludeMap[vulnID] = true
						oldVulnsExcludeMap[oldVulnID] = true

						dedupVulns = append(dedupVulns, &models.DeduplicatedVulnerabilityDeduplicationRequestDTO{
							ID:                oldVuln.ID,
							Severity:          vuln.Severity,
							Category:          vuln.Category,
							KeyProperties:     vuln.KeyProperties,
							DisplayProperties: vuln.DisplayProperties,
						})
						break
					}
				}
				if !match && step == 3 {
					// NEW
					newVulns = append(newVulns, vuln)
				}
			}
		}
	}

	return newVulns, dedupVulns, nil
}
