package yodax

import (
	"a.yandex-team.ru/security/impulse/api/worker/internal/dedup/common"
	"a.yandex-team.ru/security/impulse/models"
)

type Result struct {
	models.ResultMeta
	Report []*models.NewVulnerabilityDeduplicationRequestDTO `json:"report"`
}

type YodaxDedupImpl struct{}

func NewDedupImpl() common.DedupImpl {
	return &YodaxDedupImpl{}
}

func (d YodaxDedupImpl) UnmarshalReport(reportRaw []byte) (*common.ReportResult, error) {
	return common.UnmarshalReport(reportRaw)
}

func (d YodaxDedupImpl) Filter(vulns []*models.NewVulnerabilityDeduplicationRequestDTO, includeFilenamePatterns []string,
	excludeFilenamePatterns []string) ([]*models.NewVulnerabilityDeduplicationRequestDTO, error) {
	return common.Filter("filename", vulns, includeFilenamePatterns, excludeFilenamePatterns)
}

func (d YodaxDedupImpl) Deduplicate(oldVulns []*models.VulnerabilityDeduplicationResponseDTO, vulns []*models.NewVulnerabilityDeduplicationRequestDTO) ([]*models.NewVulnerabilityDeduplicationRequestDTO, []*models.DeduplicatedVulnerabilityDeduplicationRequestDTO, error) {
	oldVulnsExcludeMap := map[int]bool{}
	newVulns := make([]*models.NewVulnerabilityDeduplicationRequestDTO, 0)
	dedupVulns := make([]*models.DeduplicatedVulnerabilityDeduplicationRequestDTO, 0)

	for _, vuln := range vulns {
		match := false
		for _, oldVuln := range oldVulns {
			if _, ok := oldVulnsExcludeMap[oldVuln.ID]; ok {
				continue
			}

			if vuln.KeyProperties["filename"] == oldVuln.KeyProperties["filename"] &&
				vuln.KeyProperties["config_hash"] == oldVuln.KeyProperties["config_hash"] &&
				vuln.KeyProperties["plugin"] == oldVuln.KeyProperties["plugin"] {
				match = true
				oldVulnsExcludeMap[oldVuln.ID] = true
				dedupVulns = append(dedupVulns, &models.DeduplicatedVulnerabilityDeduplicationRequestDTO{
					ID:                oldVuln.ID,
					Severity:          vuln.Severity,
					Category:          vuln.Category,
					KeyProperties:     vuln.KeyProperties,
					DisplayProperties: vuln.DisplayProperties,
				})
				break
			}
		}
		if !match {
			newVulns = append(newVulns, vuln)
		}
	}

	return newVulns, dedupVulns, nil
}
