package infra

import (
	"a.yandex-team.ru/library/go/yandex/tvm/tvmtool"
	_callback "a.yandex-team.ru/security/impulse/api/internal/callback"
	_db "a.yandex-team.ru/security/impulse/api/internal/db"
	_sandbox "a.yandex-team.ru/security/impulse/api/internal/sandbox"
	_secnotify "a.yandex-team.ru/security/impulse/api/internal/secnotify"
	"a.yandex-team.ru/security/impulse/api/worker/internal/config"
	_queue "a.yandex-team.ru/security/impulse/pkg/queue"
	"a.yandex-team.ru/security/impulse/pkg/s3"
)

type Infra struct {
	CFG         *config.Config
	Queue       _queue.Queue
	DB          *_db.DB
	Sandbox     _sandbox.API
	Secnotify   _secnotify.API
	TVM         *tvmtool.Client
	S3          s3.S3Downloader
	CallbackAPI _callback.API
}

func New(cfg *config.Config) (i Infra, err error) {
	i = Infra{
		CFG: cfg,
	}
	i.Queue, err = _queue.New(cfg.QueueConfig())
	if err != nil {
		return
	}
	i.Secnotify = _secnotify.New(cfg.SecNotifyConfig())
	i.CallbackAPI = _callback.New()

	if cfg.UseAuth {
		i.TVM, err = tvmtool.NewAnyClient()
		if err != nil {
			return
		}
		i.Secnotify.SetTVMClient(i.TVM)
		i.CallbackAPI.SetTVMClient(i.TVM)
	}
	i.DB, err = _db.New(cfg.DBConfig())
	if err != nil {
		return
	}
	i.Sandbox = _sandbox.New(cfg.SandboxConfig())
	i.S3, err = s3.NewDownloader(cfg.S3Config())
	if err != nil {
		return
	}
	return

}
