package models

import "time"

type (
	CodeQLDatabase struct {
		ID             int       `json:"id" db:"id"`
		OrganizationID int       `json:"organization_id" db:"organization_id"`
		ProjectID      int       `json:"project_id" db:"project_id"`
		Language       string    `json:"language" db:"language"`
		Tag            string    `json:"tag" db:"tag"`
		MdsURL         string    `json:"mds_url" db:"mds_url"`
		ArchiveTime    time.Time `json:"archive_time" db:"archive_time"`
		Revision       string    `json:"revision" db:"revision"`
	}

	CodeQLDatabaseSaveRequestDTO struct {
		MdsURL   string `json:"mds_url"`
		Revision string `json:"revision"`
	}

	CodeQLDatabaseSearchRequestDTO struct {
		MdsURL string `json:"mds_url"`
	}

	CodeQLBuildTask struct {
		ID             int   `json:"id" db:"id"`
		OrganizationID int   `json:"organization_id" db:"organization_id"`
		ProjectID      int   `json:"project_id" db:"project_id"`
		SandboxTaskID  int   `json:"sandbox_task_id" db:"sandbox_task_id"`
		StartTime      int64 `json:"start_time" db:"start_time"`
	}

	CodeQLBuildOldestTask struct {
		OrganizationID int   `json:"organization_id" db:"organization_id"`
		ProjectID      int   `json:"project_id" db:"project_id"`
		StartTime      int64 `json:"start_time" db:"start_time"`
	}
)
