package models

type (
	CronRequestDTO struct {
		WorkflowID      string         `json:"workflow_id" form:"workflow_id" query:"workflow_id"`
		Parameters      TaskParameters `json:"parameters" form:"parameters" query:"parameters"`
		Analysers       TaskAnalysers  `json:"analysers" form:"analysers" query:"analysers"`
		Spec            string         `json:"spec" form:"spec" query:"spec"`
		Description     string         `json:"description" form:"description" query:"description"`
		CallbackURL     string         `json:"callback_url" form:"callback_url" query:"callback_url"`
		NonTemplateScan bool           `json:"non_template_scan" form:"non_template_scan" query:"non_template_scan"`
	}

	CronUpdateRequestDTO struct {
		Parameters      TaskParameters `json:"parameters" form:"parameters" query:"parameters"`
		Analysers       TaskAnalysers  `json:"analysers" form:"analysers" query:"analysers"`
		Spec            string         `json:"spec" form:"spec" query:"spec"`
		Description     string         `json:"description" form:"description" query:"description"`
		CallbackURL     string         `json:"callback_url" form:"callback_url" query:"callback_url"`
		NonTemplateScan bool           `json:"non_template_scan" form:"non_template_scan" query:"non_template_scan"`
	}

	Cron struct {
		ID              int            `json:"id" db:"id"`
		Spec            string         `json:"spec" db:"spec"`
		NextTime        int64          `json:"next_time" db:"next_time"`
		IsRunning       bool           `json:"is_running" db:"is_running"`
		Description     string         `json:"description" db:"description"`
		OrganizationID  int            `json:"organization_id" db:"organization_id"`
		ProjectID       int            `json:"project_id" db:"project_id"`
		WorkflowID      string         `json:"workflow_id" db:"workflow_id"`
		Parameters      TaskParameters `json:"parameters" db:"parameters"`
		Analysers       TaskAnalysers  `json:"analysers" db:"analysers"`
		CallbackURL     string         `json:"callback_url" db:"callback_url"`
		NonTemplateScan bool           `json:"non_template_scan" db:"non_template_scan"`
	}

	CronResponseDTO struct {
		Cron
		Workflow string `json:"workflow" db:"workflow"`
	}
)
