package models

const (
	VIEW   = "view"
	TRIAGE = "triage"
	ADMIN  = "admin"
)

type (
	NodeName struct {
		Ru string `json:"ru"`
		En string `json:"en"`
	}
	Node struct {
		Slug   string                 `json:"slug"`
		Name   NodeName               `json:"name"`
		Values map[string]interface{} `json:"values,omitempty"`
	}
	NodeValue struct {
		Name  NodeName `json:"name"`
		Roles *Node    `json:"roles,omitempty"`
	}

	IdmUser struct {
		ID       int    `json:"id" db:"id"`
		Login    string `json:"login" db:"login"`
		IsTvmApp bool   `json:"is_tvm_app" db:"is_tvm_app"`
	}
	IdmUserRole struct {
		UserID           int    `json:"user_id" db:"user_id"`
		OrganizationID   int    `json:"organization_id" db:"organization_id"`
		OrganizationSlug string `json:"organization_slug" db:"organization_slug"`
		ProjectID        int    `json:"project_id" db:"project_id"`
		ProjectSlug      string `json:"project_slug" db:"project_slug"`
		Role             string `json:"role" db:"role"`
	}

	IdmInfoResponseDTO struct {
		Code  int   `json:"code"`
		Roles *Node `json:"roles,omitempty"`
	}
	IdmResponseDTO struct {
		Code    int    `json:"code"`
		Warning string `json:"warning,omitempty"`
		Error   string `json:"error,omitempty"`
		Fatal   string `json:"fatal,omitempty"`
	}
	IdmUserAllRolesDTO struct {
		Login       string        `json:"login"`
		Roles       []*IdmRoleDTO `json:"roles"`
		SubjectType string        `json:"subject_type"`
	}
	IdmAllRolesResponseDTO struct {
		Code  int                   `json:"code"`
		Users []*IdmUserAllRolesDTO `json:"users"`
	}
	IdmAddRoleRequestDTO struct {
		Login       string `json:"login" form:"login"`
		Role        string `json:"role" form:"role"`
		SubjectType string `json:"subject_type" form:"subject_type"`
	}
	IdmRemoveRoleRequestDTO struct {
		Login       string `json:"login" form:"login"`
		Role        string `json:"role" form:"role"`
		SubjectType string `json:"subject_type" form:"subject_type"`
		Fired       int    `json:"fired" form:"fired"`
	}
	IdmRoleDTO struct {
		Organization string `json:"organization,omitempty" form:"organization"`
		Project      string `json:"project,omitempty" form:"project"`
		Role         string `json:"role,omitempty" form:"role"`
	}
)
