package models

type (
	OrganizationRequestDTO struct {
		Name         string `json:"name"`
		Slug         string `json:"slug"`
		TrackerQueue string `json:"tracker_queue"`
		ABCServiceID int    `json:"abc_service_id"`
	}

	OrganizationUpdateRequestDTO struct {
		Name         string `json:"name"`
		TrackerQueue string `json:"tracker_queue"`
		ABCServiceID int    `json:"abc_service_id"`
	}

	CreateOrganizationResponseDTO struct {
		ID int `json:"id"`
	}

	Organization struct {
		ID           int    `json:"id" db:"id"`
		Name         string `json:"name" db:"name"`
		Slug         string `json:"slug" db:"slug"`
		TrackerQueue string `json:"tracker_queue" db:"tracker_queue"`
		ABCServiceID int    `json:"abc_service_id" db:"abc_service_id"`
		Deleted      bool   `db:"deleted"`
	}

	OrganizationStatistics struct {
		TotalVulnerabilitiesCount               int `json:"total_vulnerabilities_count" db:"total_vulnerabilities_count"`
		TotalNotFalseVulnerabilitiesCount       int `json:"total_not_false_count" db:"total_not_false_count"`
		TotalNotReviewedVulnerabilitiesCount    int `json:"total_not_reviewed_count" db:"total_not_reviewed_count"`
		BlockerNotFalseVulnerabilitiesCount     int `json:"blocker_not_false_count" db:"blocker_not_false_count"`
		BlockerNotReviewedVulnerabilitiesCount  int `json:"blocker_not_reviewed_count" db:"blocker_not_reviewed_count"`
		CriticalNotFalseVulnerabilitiesCount    int `json:"critical_not_false_count" db:"critical_not_false_count"`
		CriticalNotReviewedVulnerabilitiesCount int `json:"critical_not_reviewed_count" db:"critical_not_reviewed_count"`
		MediumNotFalseVulnerabilitiesCount      int `json:"medium_not_false_count" db:"medium_not_false_count"`
		MediumNotReviewedVulnerabilitiesCount   int `json:"medium_not_reviewed_count" db:"medium_not_reviewed_count"`
		LowNotFalseVulnerabilitiesCount         int `json:"low_not_false_count" db:"low_not_false_count"`
		LowNotReviewedVulnerabilitiesCount      int `json:"low_not_reviewed_count" db:"low_not_reviewed_count"`
		InfoNotFalseVulnerabilitiesCount        int `json:"info_not_false_count" db:"info_not_false_count"`
		InfoNotReviewedVulnerabilitiesCount     int `json:"info_not_reviewed_count" db:"info_not_reviewed_count"`
	}

	OrganizationInfo struct {
		Organization
		Statistics OrganizationStatistics `json:"statistics"`
	}
)
