package models

import "time"

type (
	ScanInstance struct {
		ID           int       `db:"id" json:"id"`
		ScanID       int       `db:"scan_id" json:"scan_id"`
		TaskID       string    `db:"task_id" json:"task_id"`
		RawReportURL string    `db:"raw_report_url" json:"raw_report_url"`
		ReportURL    string    `db:"report_url" json:"report_url"`
		StartTime    time.Time `db:"start_time" json:"start_time"`
		EndTime      time.Time `db:"end_time" json:"end_time"`
		CommitHash   string    `db:"commit_hash" json:"commit_hash"`
		ScanTypeName string    `db:"scan_type_name" json:"scan_type_name"`
	}

	ScanInstanceStatistics struct {
		TotalVulnerabilitiesCount               int `json:"total_vulnerabilities_count" db:"total_vulnerabilities_count"`
		TotalNotFalseVulnerabilitiesCount       int `json:"total_not_false_count" db:"total_not_false_count"`
		TotalNotReviewedVulnerabilitiesCount    int `json:"total_not_reviewed_count" db:"total_not_reviewed_count"`
		BlockerNotFalseVulnerabilitiesCount     int `json:"blocker_not_false_count" db:"blocker_not_false_count"`
		BlockerNotReviewedVulnerabilitiesCount  int `json:"blocker_not_reviewed_count" db:"blocker_not_reviewed_count"`
		CriticalNotFalseVulnerabilitiesCount    int `json:"critical_not_false_count" db:"critical_not_false_count"`
		CriticalNotReviewedVulnerabilitiesCount int `json:"critical_not_reviewed_count" db:"critical_not_reviewed_count"`
		MediumNotFalseVulnerabilitiesCount      int `json:"medium_not_false_count" db:"medium_not_false_count"`
		MediumNotReviewedVulnerabilitiesCount   int `json:"medium_not_reviewed_count" db:"medium_not_reviewed_count"`
		LowNotFalseVulnerabilitiesCount         int `json:"low_not_false_count" db:"low_not_false_count"`
		LowNotReviewedVulnerabilitiesCount      int `json:"low_not_reviewed_count" db:"low_not_reviewed_count"`
		InfoNotFalseVulnerabilitiesCount        int `json:"info_not_false_count" db:"info_not_false_count"`
		InfoNotReviewedVulnerabilitiesCount     int `json:"info_not_reviewed_count" db:"info_not_reviewed_count"`
	}

	ScanInstanceInfo struct {
		ScanInstance           ScanInstance           `json:"instance"`
		ScanInstanceStatistics ScanInstanceStatistics `json:"statistics"`
	}
)
