package models

import (
	"database/sql/driver"
	"encoding/json"
	"time"

	"golang.org/x/xerrors"
)

type HistoryActionType string

const (
	ChangeStatusAction HistoryActionType = "change_status"
	AddCommentAction   HistoryActionType = "add_comment"
)

func (s *HistoryActionType) Scan(value interface{}) error {
	asString, ok := value.(string)
	if !ok {
		return xerrors.Errorf("Scan source is not string, but %T", value)
	}
	*s = HistoryActionType(asString)
	return nil
}

func (s HistoryActionType) Value() (driver.Value, error) {
	return string(s), nil
}

func (s HistoryActionType) MarshalJSON() ([]byte, error) {
	return json.Marshal(string(s))
}

type (
	VulnerabilityHistoryAction struct {
		ID              int                `json:"id" form:"id" query:"id" db:"id"`
		VulnerabilityID int                `json:"vulnerability_id" form:"vulnerability_id" query:"vulnerability_id" db:"vulnerability_id"`
		ActionType      *HistoryActionType `json:"action_type,omitempty" db:"action_type" sql:"type:history_action_type"`
		ActionTime      time.Time          `json:"action_time" db:"action_time"`
		ActionText      string             `json:"action_text" db:"action_text"`
		Login           string             `json:"login" db:"login"`
	}

	VulnerabilityCommentRequestDTO struct {
		CommentText string `json:"comment_text"`
	}
)
