package models

type (
	Workflow struct {
		ID          string `json:"id" db:"id"`
		Name        string `json:"name" db:"name"`
		Description string `json:"description" db:"description"`
		URL         string `json:"url" db:"url"`
	}

	// swagger:model
	WorkflowNewRequestDTO struct {
		// Required: true
		ID          string `json:"id" form:"id" query:"id"`
		Description string `json:"description" form:"description" query:"description"`
	}

	WorkflowResponseDTO struct {
		Workflow
		ScanTypes []string `json:"scan_types"`
	}

	WorkflowExtendedResponseDTO struct {
		WorkflowResponseDTO
		Parameters map[string]WorkflowParameter `json:"parameters"`
	}

	WorkflowParameter struct {
		Default    interface{}       `json:"default"`
		Component  string            `json:"component"`
		Label      string            `json:"label"`
		Properties map[string]string `json:"properties"`
	}

	WorkflowIDRequestDTO struct {
		ID string `json:"workflow_id"`
	}
)
