#!/usr/bin/env bash
apt-get update
apt-get install -y python3.8 python-pip python3-pip git subversion curl zip

python -m pip install --upgrade pip
python -m pip install --ignore-installed six
python -m pip install bandit --upgrade --ignore-installed six

python3.8 -m pip install --upgrade pip
python3.8 -m pip install --ignore-installed six
python3.8 -m pip install bandit

python3.8 -m pip install --ignore-installed setuptools
python3.8 -m pip install -i https://pypi.yandex-team.ru/simple/ yodax
python3.8 -m pip install boto3

curl https://dl.google.com/go/go1.17.3.linux-amd64.tar.gz -o go1.17.3.tar.gz
tar -C /usr/local -xzf go1.17.3.tar.gz
cp /usr/local/go/bin/* /usr/local/bin/
curl -sfL https://raw.githubusercontent.com/securego/gosec/master/install.sh | sh

python -m pip install -i https://pypi.yandex-team.ru/simple/ yadi_bin
curl -sL https://tools.sec.yandex-team.ru/api/v1/release/yadi-arc/linux/latest/yadi-arc -o /usr/local/bin/yadi-arc
chmod +x /usr/local/bin/yadi-arc

curl -sL https://deb.nodesource.com/setup_10.x | bash -
apt-get install -y  nodejs
npm i -g eslint@5 eslint-plugin-standard@4.0.1 eslint-plugin-import@2.20.2 eslint-plugin-node@11.1.0 \
eslint-plugin-promise@4.2.1 eslint-config-standard@14.1.1 eslint-config-semistandard@15.0.0 \
eslint-plugin-scanjs-rules@0.2.1 eslint-plugin-no-unsanitized@3.1.0 eslint-plugin-prototype-pollution-security-rules@1.0.6 \
eslint-plugin-angularjs-security-rules@1.0.7 eslint-plugin-react@7.19.0 eslint-plugin-security@1.4.0 \
eslint-plugin-no-wildcard-postmessage@0.2.0 babel-eslint@10.1.0 typescript@3.8.3 @typescript-eslint/parser@3.9.0 || true
npm i -g veendor

apt-get install -y openjdk-11-jdk maven unzip
curl -sL https://github.com/find-sec-bugs/find-sec-bugs/releases/download/version-1.10.1/findsecbugs-cli-1.10.1.zip -o /tmp/findsecbugs.zip
unzip /tmp/findsecbugs.zip -d /tmp
chmod +x /tmp/findsecbugs.sh
sed -i -E 's/java/java -Xmx2048M -Xss1024M/g' /tmp/findsecbugs.sh

python3.8 -m pip install semgrep

mkdir -p /usr/local/bin/codeql
curl -L https://github.com/github/codeql-cli-binaries/releases/download/v2.9.1/codeql-linux64.zip -o /usr/local/bin/codeql/codeql-linux64.zip
unzip /usr/local/bin/codeql/codeql-linux64.zip -d /usr/local/bin/codeql
mv /usr/local/bin/codeql/codeql /usr/local/bin/codeql/codeql-cli
git clone https://github.com/github/codeql /usr/local/bin/codeql/codeql-repo
git clone https://github.com/github/codeql-go /usr/local/bin/codeql/codeql-go-repo
curl -L https://github.com/github/codeql/archive/v1.27.0.zip -o /usr/local/bin/codeql/codeql-queries.zip
curl -L https://github.com/github/codeql-go/archive/v1.27.0.zip -o /usr/local/bin/codeql/codeql-go-queries.zip

DETECT_VERSION_KEY=DETECT_LATEST DETECT_DOWNLOAD_ONLY=1 DETECT_JAR_DOWNLOAD_DIR=/usr/local/bin/blackduck bash <(curl -s -L https://detect.synopsys.com/detect.sh)
chown sandbox /usr/local/bin/blackduck
git config --system --add url."git@bb.yandex-team.ru:".insteadOf "https://bb.yandex-team.ru/scm"
git config --system --add url."git@a.yandex-team.ru:".insteadOf "https://a.yandex-team.ru/scm"

echo -e '#!/bin/sh\nexec echo "$GIT_PASSWORD"' > /usr/local/bin/git_password.sh
chmod +x /usr/local/bin/git_password.sh

curl https://crls.yandex.net/YandexInternalRootCA.crt -o /usr/local/share/ca-certificates/YandexInternalRootCA.crt
update-ca-certificates

apt-get clean
apt-get autoclean
rm -rf /tmp/* /var/lib/apt/lists/* /var/cache/apt/*.bin
find /var/log -iname '*.gz' -delete
find /var/log -iname '*.1' -delete
