package config

import (
	"fmt"
	"strings"

	"a.yandex-team.ru/security/impulse/pkg/queue"
	"a.yandex-team.ru/security/impulse/pkg/s3"
)

type (
	Config struct {
		S3Endpoint        string
		S3Region          string
		S3AccessKeyID     string
		S3SecretAccessKey string
		SqsEndpoint       string
		SqsAccount        string
		SqsRetries        int
		SqsOAuthToken     string
	}
)

func (c *Config) S3Config() *s3.Options {
	return &s3.Options{
		Endpoint:        c.S3Endpoint,
		Region:          c.S3Region,
		AccessKeyID:     c.S3AccessKeyID,
		SecretAccessKey: c.S3SecretAccessKey,
	}
}

func (c *Config) ReportsQueueURL() string {
	return fmt.Sprintf("%s/%s/%s",
		strings.TrimRight(c.SqsEndpoint, "/"),
		c.SqsAccount,
		"reports",
	)
}

func (c *Config) QueueConfig() *queue.Options {
	return &queue.Options{
		Endpoint:   c.SqsEndpoint,
		Account:    c.SqsAccount,
		MaxRetries: c.SqsRetries,
		AuthType:   queue.AuthOAuth,
		OAuthToken: c.SqsOAuthToken,
	}
}
