package dedup

import (
	"bufio"
	"crypto/sha256"
	"encoding/hex"
	"os"
	"regexp"
	"strings"
)

var (
	spaceRe = regexp.MustCompile(`\s+`)
)

func GetLineHash(path string, lineNumber int) (string, error) {
	file, err := os.Open(path)
	defer func() { _ = file.Close() }()

	if err != nil {
		return "", err
	}

	reader := bufio.NewReader(file)

	var line string
	var currentLineNumber = 1

	for {
		line, err = reader.ReadString('\n')
		if err != nil {
			return "", err
		}
		if currentLineNumber == lineNumber {
			line = strings.TrimSpace(line)
			line = spaceRe.ReplaceAllString(line, " ")
			hash := sha256.Sum256([]byte(line))
			return hex.EncodeToString(hash[:]), nil
		}
		currentLineNumber = currentLineNumber + 1
	}
}

func GetStringHash(data string) (string, error) {
	data = strings.TrimSpace(data)
	data = spaceRe.ReplaceAllString(data, " ")
	hash := sha256.Sum256([]byte(data))
	return hex.EncodeToString(hash[:]), nil
}
