package main

const BlackduckURL string = "https://blackduck.cloud.yandex.net"

type authInfo struct {
	BearerToken           string  `json:"bearerToken"`
	ExpiresInMilliseconds float64 `json:"expiresInMilliseconds"`
}

type blackduckMeta struct {
	Href  string   `json:"href"`
	Allow []string `json:"allow"`
	Links []struct {
		Rel  string `json:"rel"`
		Href string `json:"href"`
	} `json:"links"`
}

type projectRepresentation struct {
	Name                     string   `json:"name"`
	Description              string   `json:"description"`
	ProjectTier              float64  `json:"projectTier"`
	ProjectLevelAdjustments  bool     `json:"projectLevelAdjustments"`
	CreatedAt                string   `json:"createdAt"`
	CreatedBy                string   `json:"createdBy"`
	CreatedByUser            string   `json:"createdByUser"`
	UpdatedAt                string   `json:"updatedAt"`
	UpdatedBy                string   `json:"updatedBy"`
	UpdatedByUser            string   `json:"updatedByUser"`
	SnippetAdjustmentApplied bool     `json:"snippetAdjustmentApplied"`
	ProjectOwner             string   `json:"projectOwner"`
	CloneCategories          []string `json:"cloneCategories"`
	CustomSignatureEnabled   bool     `json:"customSignatureEnabled"`
	//CustomSignatureDepth     float64       `json:"customSignatureDepth"`
	Meta blackduckMeta `json:"_meta"`
}

type projectRepresentations struct {
	TotalCount float64                 `json:"totalCount"`
	Items      []projectRepresentation `json:"items"`
	Meta       blackduckMeta           `json:"_meta"`
}

type projectVersionRepresentation struct {
	VersionName     string `json:"versionName"`
	Nickname        string `json:"nickname"`
	ReleaseComments string `json:"releaseComments"`
	Phase           string `json:"phase"`
	Distribution    string `json:"distribution"`
	License         struct {
		LicenseType string `json:"licenseType"`
		Licenses    []struct {
			License              string `json:"license"`
			Name                 string `json:"name"`
			LicenseFamilySummary struct {
				Name string `json:"name"`
				Href string `json:"href"`
			} `json:"licenseFamilySummary"`
			Licenses []interface{} `json:"licenses"`
		} `json:"licenses"`
		LicenseDisplay string `json:"licenseDisplay"`
	} `json:"license"`
	CreatedAt            string        `json:"createdAt"`
	CreatedBy            string        `json:"createdBy"`
	CreatedByUser        string        `json:"createdByUser"`
	ReleasedOn           string        `json:"releasedOn"`
	SettingUpdatedAt     string        `json:"settingUpdatedAt"`
	SettingUpdatedBy     string        `json:"settingUpdatedBy"`
	SettingUpdatedByUser string        `json:"settingUpdatedByUser"`
	Source               string        `json:"source"`
	Meta                 blackduckMeta `json:"_meta"`
}

type projectVersionRepresentations struct {
	TotalCount int64                          `json:"totalCount"`
	Items      []projectVersionRepresentation `json:"items"`
	Meta       blackduckMeta                  `json:"_meta"`
}

type vulnsRepresentation struct {
	TotalCount int64 `json:"totalCount"`
	Items      []struct {
		ComponentVersion           string `json:"componentVersion"`
		ComponentName              string `json:"componentName"`
		ComponentVersionName       string `json:"componentVersionName"`
		ComponentVersionOriginName string `json:"componentVersionOriginName"`
		ComponentVersionOriginID   string `json:"componentVersionOriginId"`
		Ignored                    bool   `json:"ignored"`
		License                    struct {
			LicenseType string `json:"licenseType"`
			Licenses    []struct {
				License        string        `json:"license"`
				Licenses       []interface{} `json:"licenses"`
				Name           string        `json:"name"`
				Ownership      string        `json:"ownership"`
				LicenseDisplay string        `json:"licenseDisplay"`
			} `json:"licenses"`
			LicenseDisplay string `json:"licenseDisplay"`
		} `json:"license"`
		VulnerabilityWithRemediation struct {
			VulnerabilityName          string  `json:"vulnerabilityName"`
			Description                string  `json:"description"`
			VulnerabilityPublishedDate string  `json:"vulnerabilityPublishedDate"`
			VulnerabilityUpdatedDate   string  `json:"vulnerabilityUpdatedDate"`
			BaseScore                  float64 `json:"baseScore"`
			OverallScore               float64 `json:"overallScore"`
			ExploitabilitySubscore     float64 `json:"exploitabilitySubscore"`
			ImpactSubscore             float64 `json:"impactSubscore"`
			Source                     string  `json:"source"`
			Severity                   string  `json:"severity"`
			RemediationStatus          string  `json:"remediationStatus"`
			CWEId                      string  `json:"cweId"`
			RemediationTargetAt        string  `json:"remediationTargetAt"`
			RemediationActualAt        string  `json:"remediationActualAt"`
			RemediationCreatedAt       string  `json:"remediationCreatedAt"`
			RemediationUpdatedAt       string  `json:"remediationUpdatedAt"`
			RemediationCreatedBy       string  `json:"remediationCreatedBy"`
			RemediationUpdatedBy       string  `json:"remediationUpdatedBy"`
			RelatedVulnerability       string  `json:"relatedVulnerability"`
		} `json:"vulnerabilityWithRemediation"`
		Meta blackduckMeta `json:"_meta"`
	}
	Meta blackduckMeta `json:"_meta"`
}
