package main

import (
	"a.yandex-team.ru/library/go/yandex/tvm"
)

const (
	// CodeqlYandexQueriesRepo = "https://github.yandex-team.ru/security/codeql-queries"
	// CodeqlYandexBranch      = "master"
	// CodeqlCustomQueriesPath = "/tmp/codeql-custom-queries"
	CodeqlHome = "/usr/local/bin/codeql"

	SelfTvmID    tvm.ClientID = 2016387
	ImpulseTvmID tvm.ClientID = 2016355
)

var SupportedLanguages = map[string]struct {
	Language          string
	NeedsCompilation  bool
	DefaultQuerySuite string
}{
	"cpp":        {"cpp", true, "cpp-selected.qls"},
	"csharp":     {"csharp", true, "csharp-security-extended.qls"},
	"java":       {"java", true, "java-selected.qls"},
	"go":         {"go", false, "go-selected.qls"},
	"python":     {"python", false, "python-selected.qls"},
	"javascript": {"javascript", false, "javascript-selected.qls"},
}
