package main

import (
	"flag"

	"a.yandex-team.ru/security/impulse/workflow/internal/nirvana"
)

func main() {
	langPtr := flag.String("lang", "", "project languages (go, python, cpp, java, javascript, csharp) (comma separated)")
	querySuitePtr := flag.String("qls", "", "query suite name (ex. go-security-extended.qls) (comma separated)")
	tvmToken := flag.String("impulse-tvm-token", "", "imPulse TVM secret")
	oauthToken := flag.String("oauth-token", "", "imPulse OAuth token")
	organizationID := flag.Int("organization-id", 0, "organization id")
	projectID := flag.Int("project-id", 0, "project id")
	queriesBranch := flag.String("queries-branch", "", "queries repositories branch")

	scanner := CodeQL{
		langsArg:       langPtr,
		qlsArg:         querySuitePtr,
		tvmToken:       tvmToken,
		oauthToken:     oauthToken,
		organizationID: organizationID,
		projectID:      projectID,
		queriesBranch:  queriesBranch,
	}
	nirvana.StaticEntrypoint(&scanner)
}
