package main

const DefaultEslintConfigFilename = "/tmp/eslintrc-impulse.js"

const DefaultEslintConfig = `
module.exports = {
  "env" : {
    "browser" : true,
    "es6" : true /** all es6 features except modules */
  },
  "plugins" : [
    // Standard Rules
    "scanjs-rules",
    "no-unsanitized",
    "prototype-pollution-security-rules",
    // NodeJS Rules
    "security",
    "no-wildcard-postmessage",
    // Augular Rules
    "angularjs-security-rules",
    // React Rules
    "react"
  ],
  "extends" : [
    /** security (include all nodeJS rules) rules**/
    "plugin:security/recommended",
  ],
  "rules" : {
    /** useful rules from eslint **/
    "security/detect-new-buffer": "off",
    "security/detect-non-literal-fs-filename": "off",
    "security/detect-non-literal-regexp": "off",
    "security/detect-non-literal-require": "off",
    "security/detect-object-injection": "off",
    "security/detect-unsafe-regex": "warn",

    /** ScanJS rules **/
    "scanjs-rules/accidental_assignment": "off",
    "scanjs-rules/assign_to_hostname" : 1,
    "scanjs-rules/assign_to_href" : 1,
    "scanjs-rules/assign_to_location" : 1,
    "scanjs-rules/assign_to_onmessage" : 1,
    "scanjs-rules/assign_to_pathname" : 1,
    "scanjs-rules/assign_to_protocol" : 1,
    "scanjs-rules/assign_to_search" : "off",
    "scanjs-rules/assign_to_src" : "off",
    "scanjs-rules/call_Function" : 1,
    "scanjs-rules/call_addEventListener" : "off",
    "scanjs-rules/call_addEventListener_deviceproximity" :  "off",
    "scanjs-rules/call_addEventListener_message" : "off",
    "scanjs-rules/call_connect" : "off",
    "scanjs-rules/call_eval" : 1,
    "scanjs-rules/call_execScript" : 1,
    "scanjs-rules/call_hide" : "off",
    "scanjs-rules/call_open_remote=true" : 1,
    "scanjs-rules/call_parseFromString" : 1,
    "scanjs-rules/call_setImmediate" : "off",
    "scanjs-rules/call_setInterval" : "off",
    "scanjs-rules/call_setTimeout" : "off",
    "scanjs-rules/identifier_indexedDB" : 1,
    "scanjs-rules/identifier_localStorage" : "off",
    "scanjs-rules/identifier_sessionStorage" : "off",
    "scanjs-rules/new_Function" : 1,
    "scanjs-rules/property_addIdleObserver" : "off",
    "scanjs-rules/property_createContextualFragment" : "off",
    "scanjs-rules/property_crypto": "off",
    "scanjs-rules/property_geolocation" : "off",
    "scanjs-rules/property_getUserMedia" : "off",
    "scanjs-rules/property_indexedDB" : "off",
    "scanjs-rules/property_localStorage" : "off",
    "scanjs-rules/property_mgmt" : "off",
    "scanjs-rules/property_sessionStorage" : "off",

    /** no-unsanitized rules**/
    "no-unsanitized/method": "off",
    "no-unsanitized/property": "error",

    /** prototype-pollution-security-rules rules**/
    "prototype-pollution-security-rules/detect-merge": 1,
    "prototype-pollution-security-rules/detect-merge-objects": 1,
    "prototype-pollution-security-rules/detect-merge-options": 1,
    "prototype-pollution-security-rules/detect-deep-extend": 1,

    /** no-wildcard-postmessage (NodeJS) rules**/
    "no-wildcard-postmessage/no-wildcard-postmessage": 1,

    /** angularjs-security-rules (Angular) rules**/
    "angularjs-security-rules/detect-angular-element-methods": "off",
    "angularjs-security-rules/detect-angular-open-redirect": "off",
    "angularjs-security-rules/detect-angular-orderBy-expressions": "off",
    "angularjs-security-rules/detect-angular-resource-loading": "off",
    "angularjs-security-rules/detect-angular-sce-disabled": "off",
    "angularjs-security-rules/detect-angular-scope-expressions": "off",
    "angularjs-security-rules/detect-angular-service-expressions": "off",
    "angularjs-security-rules/detect-angular-trustAs-methods": "off",
    "angularjs-security-rules/detect-angular-trustAsCss-method": "off",
    "angularjs-security-rules/detect-angular-trustAsHtml-method": "off",
    "angularjs-security-rules/detect-angular-sce-disabled": "off",
    "angularjs-security-rules/detect-angular-trustAsJs-method": "off",
    "angularjs-security-rules/detect-angular-trustAsResourceUrl-method": "off",
    "angularjs-security-rules/detect-angular-trustAsUrl-method": "off",
    "angularjs-security-rules/detect-third-party-angular-translate": "off",

    /** react (React) rules**/
    // Some rules have been removed which require additional specific configuration
    "react/no-danger": "error",
    "react/jsx-no-target-blank": "warn"

  },
  "settings" : {
    "react" : {
        "version": "latest"
    }
  },
  "parser": "babel-eslint",
  "parserOptions": {
    "ecmaVersion": 2018,
    "sourceType": "module",
    "ecmaFeatures": {
      "jsx": true,
      "modules": true
    }
  }
};
`
