package app

import (
	"net/http"

	"a.yandex-team.ru/library/go/core/buildinfo"
)

var (
	okRsp = []byte(`ok`)
)

func (a *App) readinessHandler(w http.ResponseWriter, r *http.Request) {
	if err := a.storage.Ping(r.Context()); err != nil {
		http.Error(w, err.Error(), http.StatusInternalServerError)
		return
	}

	_, _ = w.Write(okRsp)
}

func (a *App) livenessHandler(w http.ResponseWriter, _ *http.Request) {
	_, _ = w.Write(okRsp)
}

func (a *App) versionHandler(w http.ResponseWriter, _ *http.Request) {
	_, _ = w.Write([]byte(buildinfo.Info.ProgramVersion))
}

func (a *App) sumdbHandler(w http.ResponseWriter, _ *http.Request) {
	http.Error(w, "not implemented yet", http.StatusNotFound)
}
