package app

import (
	"fmt"
	"net/http"

	"a.yandex-team.ru/security/kirby/internal/middleware"
)

func setResponseCacheControlHeader(w http.ResponseWriter, maxAge int) {
	cacheControl := ""
	if maxAge >= 0 {
		cacheControl = fmt.Sprintf("public, max-age=%d", maxAge)
	} else {
		cacheControl = "must-revalidate, no-cache, no-store"
	}

	w.Header().Set("Cache-Control", cacheControl)
}

func setResponseContentType(w http.ResponseWriter, ct string) {
	w.Header().Set("Content-Type", ct)
}

func errResponse(w http.ResponseWriter, r *http.Request, err error, code int) {
	msg := fmt.Sprintf("request failed (req_id=%s): %v", middleware.GetReqID(r.Context()), err)
	http.Error(w, msg, code)
}
