package app

import (
	"github.com/go-chi/chi/v5"

	"a.yandex-team.ru/library/go/httputil/middleware/recovery"
	"a.yandex-team.ru/security/kirby/internal/middleware"
)

func newRouter(a *App) *chi.Mux {
	r := chi.NewRouter()
	r.Use(recovery.New(recovery.WithLogger(a.log.Structured())))

	r.Get("/ping/readiness", a.readinessHandler)
	r.Get("/ping/liveness", a.livenessHandler)
	r.Get("/version", a.versionHandler)
	r.Get("/sumdb/*", a.sumdbHandler)

	r.Group(func(r chi.Router) {
		r.Use(middleware.RequestID)
		r.Use(middleware.LogRequest(a.log))
		r.Get("/*", a.modHandler)
	})

	return r
}
