package gobin

import (
	"fmt"
	"os/exec"
)

func CheckRequirements() error {
	requiredBinaries := []string{
		"go",
		"git",
		"hg",
	}

	for _, bin := range requiredBinaries {
		_, err := exec.LookPath(bin)
		if err != nil {
			return fmt.Errorf("failed to find required binary %s: %w", bin, err)
		}
	}
	return nil
}
