package resolver

import (
	"context"
	"io"
	"time"

	"a.yandex-team.ru/security/kirby/internal/module"
)

type Resolver interface {
	Name() string
	List(ctx context.Context, m *module.Module) ([]byte, error)
	Latest(ctx context.Context, m *module.Module) (InfoResult, error)
	Info(ctx context.Context, m *module.Module) (InfoResult, error)
	Download(ctx context.Context, m *module.Module) (DownloadResult, error)
}

type DownloadResult struct {
	Info []byte
	Mod  []byte
	Zip  io.ReadCloser
}

type InfoResult struct {
	Version string
	Time    time.Time
}
