package storage

import (
	"context"
	"io"
	"time"
)

type Storage interface {
	Ping(ctx context.Context) error
	Put(ctx context.Context, key string, item PutItem) error
	Get(ctx context.Context, key string) (GetItem, error)
	Head(ctx context.Context, key string) (HeadItem, error)
	WriteTo(ctx context.Context, key string, dst io.Writer) error
	DownloadURI(path string) string
}

type GetItem struct {
	Body        io.ReadCloser
	ContentType string
	UpdatedAt   time.Time
}

type PutItem struct {
	Body        io.Reader
	ContentType string
}

type HeadItem struct {
	ContentType string
	UpdatedAt   time.Time
}
