#include <security/libs/cpp/log/log.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TLoggerTest) {


Y_UNIT_TEST(BasicMessage) {
    TStringStream ss;
    NSecurityHelpers::TLogger logger(ss, NSecurityHelpers::TLOG_ERR);

    logger.Write(NSecurityHelpers::TLOG_INFO, "test");
    UNIT_ASSERT_EQUAL_C(ss.Size(), 0, "logger must NOT write message with Info log level");
    logger.Write(NSecurityHelpers::TLOG_WARNING, "test");
    UNIT_ASSERT_EQUAL_C(ss.Size(), 0, "logger must NOT write message with Waring log level");
    logger.Write(NSecurityHelpers::TLOG_ERR, "test");
    UNIT_ASSERT_C(ss.Size() > 0, "logger must write message with Error log level");
    UNIT_ASSERT_STRING_CONTAINS_C(ss.Str(), "test", "logger must contain test message");
}

Y_UNIT_TEST(WriteArgs) {
    TStringStream ss;
    NSecurityHelpers::TLogger logger(ss);

    logger.Write(NSecurityHelpers::TLOG_INFO, "test", "a", "b");
    UNIT_ASSERT_STRING_CONTAINS(ss.Str(), "test");
    UNIT_ASSERT_STRING_CONTAINS(ss.Str(), "a=\"b\"");
    ss.Clear();

    logger.Write(NSecurityHelpers::TLOG_INFO, "test", "a", "b", "c", "d");
    UNIT_ASSERT_STRING_CONTAINS(ss.Str(), "test");
    UNIT_ASSERT_STRING_CONTAINS(ss.Str(), "a=\"b\"");
    UNIT_ASSERT_STRING_CONTAINS(ss.Str(), "c=\"d\"");
}
}
