package acler

import "a.yandex-team.ru/library/go/yandex/tvm"

type (
	Options struct {
		Users       []string
		Departments []string
		ABCRoles    []string
		TVMs        []tvm.ClientID
		StaffToken  string
	}

	Option func(*Options)
)

func User(user ...string) Option {
	return func(args *Options) {
		args.Users = append(args.Users, user...)
	}
}

func Department(department ...string) Option {
	return func(args *Options) {
		args.Departments = append(args.Departments, department...)
	}
}

func AbcRole(role ...string) Option {
	return func(args *Options) {
		args.ABCRoles = append(args.ABCRoles, role...)
	}
}

func TVM(tvmID ...tvm.ClientID) Option {
	return func(args *Options) {
		args.TVMs = append(args.TVMs, tvmID...)
	}
}

func StaffToken(token string) Option {
	return func(args *Options) {
		args.StaffToken = token
	}
}
