package staff

import (
	"encoding/json"
	"fmt"
	"io"
	"net/http"
	"net/url"

	"a.yandex-team.ru/security/libs/go/yahttp"
)

func ResolveDepartment(authToken, department string) (logins []string, err error) {
	params := url.Values{
		"official.is_dismissed": {"false"},
		"department_group.url":  {department},
		"_fields":               {"login"},
	}
	req, err := http.NewRequest("GET", "https://staff-api.yandex-team.ru/v3/persons?"+params.Encode(), nil)
	if err != nil {
		return
	}

	req.Header.Set("Authorization", fmt.Sprintf("OAuth %s", authToken))
	resp, err := yahttp.DoRequest(req)
	if err != nil {
		return
	}

	defer func() {
		_, _ = io.CopyN(io.Discard, resp.Body, 128<<10)
		_ = resp.Body.Close()
	}()

	if resp.StatusCode != 200 {
		err = fmt.Errorf("failed to get staff persons: %d", resp.StatusCode)
		return
	}

	var personInfo struct {
		Result []struct {
			Login string
		}
	}

	err = json.NewDecoder(resp.Body).Decode(&personInfo)
	if err != nil {
		return
	}

	for _, user := range personInfo.Result {
		logins = append(logins, user.Login)
	}
	return
}

func ResolveABCRole(authToken, role string) (logins []string, err error) {
	params := url.Values{
		"official.is_dismissed": {"false"},
		"groups.group.url":      {role},
		"_fields":               {"login"},
	}
	req, err := http.NewRequest("GET", "https://staff-api.yandex-team.ru/v3/persons?"+params.Encode(), nil)
	if err != nil {
		return
	}

	req.Header.Set("Authorization", fmt.Sprintf("OAuth %s", authToken))
	resp, err := yahttp.DoRequest(req)
	if err != nil {
		return
	}

	defer func() {
		_, _ = io.CopyN(io.Discard, resp.Body, 128<<10)
		_ = resp.Body.Close()
	}()

	if resp.StatusCode != 200 {
		err = fmt.Errorf("failed to get staff persons: %d", resp.StatusCode)
		return
	}

	var personInfo struct {
		Result []struct {
			Login string
		}
	}

	err = json.NewDecoder(resp.Body).Decode(&personInfo)
	if err != nil {
		return
	}

	for _, user := range personInfo.Result {
		logins = append(logins, user.Login)
	}
	return
}
