package arc

import (
	"bytes"
	"encoding/json"
	"fmt"
	"os"
	"os/exec"
	"strings"
)

func QueryStatus() (*Status, error) {
	return QueryStatusIn(".")
}

func QueryStatusIn(targets ...string) (*Status, error) {
	args := append([]string{"status", "--json"}, targets...)
	cmd := exec.Command("arc", args...)
	var stdout bytes.Buffer
	cmd.Stdout = &stdout
	cmd.Stderr = os.Stderr

	if err := cmd.Run(); err != nil {
		return nil, fmt.Errorf("arc %s: %w", strings.Join(args, " "), err)
	}

	var out RspStatus
	if err := json.Unmarshal(stdout.Bytes(), &out); err != nil {
		return nil, fmt.Errorf("failed to unmarshal result: %w", err)
	}

	return &out.Status, nil
}
