package arc

import (
	"encoding/json"
	"fmt"
)

var _ json.Marshaler = (*FileStatus)(nil)
var _ json.Unmarshaler = (*FileStatus)(nil)

type FileStatus int

const (
	FileStatusNone FileStatus = iota
	FileStatusNewFile
	FileStatusRenamed
	FileStatusCopied
	FileStatusDeleted
	FileStatusModified
	FileStatusUntracked
)

func (s FileStatus) MarshalJSON() ([]byte, error) {
	return json.Marshal(s.String())
}

func (s *FileStatus) UnmarshalJSON(in []byte) error {
	var val string
	if err := json.Unmarshal(in, &val); err != nil {
		return err
	}

	switch val {
	case "new file":
		*s = FileStatusNewFile
	case "renamed":
		*s = FileStatusRenamed
	case "copied":
		*s = FileStatusCopied
	case "deleted":
		*s = FileStatusDeleted
	case "modified":
		*s = FileStatusModified
	case "untracked":
		*s = FileStatusUntracked
	default:
		return fmt.Errorf("unknown value: %s", val)
	}

	return nil
}

func (s FileStatus) String() string {
	switch s {
	case FileStatusNone:
		return "n/a"
	case FileStatusNewFile:
		return "new file"
	case FileStatusRenamed:
		return "renamed"
	case FileStatusCopied:
		return "copied"
	case FileStatusDeleted:
		return "deleted"
	case FileStatusModified:
		return "modified"
	case FileStatusUntracked:
		return "untracked"
	default:
		return fmt.Sprintf("unknown: %d", s)
	}
}
