package archer

import (
	"compress/bzip2"
)

type TarBzip2Walker struct{}

func (z *TarBzip2Walker) FileWalk(src string, opts FileWalkOpts, walkFn FileWalkFunc) error {
	f, err := OpenFile(src)
	if err != nil {
		return err
	}
	defer silenceClose(f)

	return z.Walk(f, opts, walkFn)
}

func (z *TarBzip2Walker) Walk(r SizeReader, opts FileWalkOpts, walkFn FileWalkFunc) error {
	bzipR := bzip2.NewReader(r)
	return tarWalk(bzipR, opts, walkFn)
}
