package archer

import (
	"compress/gzip"
)

type TarGzipWalker struct{}

func (z *TarGzipWalker) FileWalk(src string, opts FileWalkOpts, walkFn FileWalkFunc) error {
	f, err := OpenFile(src)
	if err != nil {
		return err
	}
	defer silenceClose(f)

	return z.Walk(f, opts, walkFn)
}

func (z *TarGzipWalker) Walk(r SizeReader, opts FileWalkOpts, walkFn FileWalkFunc) error {
	gzipR, err := gzip.NewReader(r)
	if err != nil {
		return err
	}
	defer silenceClose(gzipR)

	return tarWalk(gzipR, opts, walkFn)
}
