package archer

import (
	"bytes"
	"io"
	"os"
)

type SizeReader interface {
	io.ReaderAt
	io.ReadCloser
	Size() int64
}

type fileReader struct {
	*os.File
	os.FileInfo
}

func OpenFile(name string) (SizeReader, error) {
	f, err := os.Open(name)
	if err != nil {
		return nil, err
	}

	fi, err := f.Stat()
	if err != nil {
		_ = f.Close()
		return nil, err
	}

	return fileReader{
		File:     f,
		FileInfo: fi,
	}, nil
}

type bytesReader struct {
	*bytes.Reader
}

func (r bytesReader) Close() error {
	return nil
}

func OpenReader(r io.Reader, size int64) (SizeReader, error) {
	data := make([]byte, int(size))
	_, err := io.ReadFull(r, data)
	if err != nil {
		return nil, err
	}

	return bytesReader{
		Reader: bytes.NewReader(data),
	}, nil
}
