package httpreplay

import (
	"errors"
	"net/url"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/security/libs/go/boombox/httpmodel"
)

const (
	ModeProxy Mode = iota
	ModeReply
)

type Option func(*Replay) error

type Mode uint8

type KeyFunc func(r *httpmodel.Request) string

func WithLogger(l log.Logger) Option {
	return func(r *Replay) error {
		r.log = l
		return nil
	}
}

func WithFollowRedirect(follow bool) Option {
	return func(r *Replay) error {
		if follow {
			r.httpc.CheckRedirect = nil
		}

		return nil
	}
}

func WithNamespace(namespace string) Option {
	return func(r *Replay) error {
		r.namespace = namespace
		return nil
	}
}

func WithKeyFunc(f KeyFunc) Option {
	return func(r *Replay) error {
		r.keyFunc = f
		return nil
	}
}

func WithProxyMode(upstream string) Option {
	return func(r *Replay) (err error) {
		if upstream == "" {
			return errors.New("empty upstream")
		}

		r.mode = ModeProxy
		r.doFunc = r.doProxy
		r.upstream, err = url.Parse(upstream)
		return
	}
}
