package chim

import (
	"net/http"
)

var xForwardedForY = http.CanonicalHeaderKey("X-Forwarded-For-Y")
var xRealIP = http.CanonicalHeaderKey("X-Real-IP")

func RealIP(h http.Handler) http.Handler {
	fn := func(w http.ResponseWriter, r *http.Request) {
		r.RemoteAddr = realIP(r)
		h.ServeHTTP(w, r)
	}

	return http.HandlerFunc(fn)
}

func realIP(r *http.Request) string {
	if xffy := r.Header.Get(xForwardedForY); xffy != "" {
		return xffy
	}

	if xrip := r.Header.Get(xRealIP); xrip != "" {
		return xrip
	}

	return r.RemoteAddr
}
